#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <pthread.h>

#define BROJ_VOZILA 10

//0 - AUTO, 1 - AUTOBUS, 2 - KAMION

pthread_mutex_t pristup = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t pristupSever = PTHREAD_COND_INITIALIZER;
pthread_cond_t pristupJug = PTHREAD_COND_INITIALIZER;

int vozilaNaMostu=0;
int autobusNaMostu=0;
int kamionNaMostu=0;
int smer = -1;



typedef struct vozilo
{
    int id;
    int tip;
    int smer;
}Vozilo;


char * vozilaStr[] =
{
    "AUTO",
    "AUTOBUS",
    "KAMION"
};

void * prelazakSever(void* arg)
{

    Vozilo* v = (Vozilo*)arg;
   

    rand()%3;
    pthread_mutex_lock(&pristup);

    printf("SEVER %d: Vozilo tipa %s ceka pred mostom, na mostu: vozila: %d, kamiona: %d, autobusa: %d\n", v->id, vozilaStr[v->tip],vozilaNaMostu,kamionNaMostu,autobusNaMostu);
  
    switch(v->tip)
    {

    
        case 0:
        while(smer==1 || kamionNaMostu>0)
        pthread_cond_wait(&pristupSever,&pristup);
        vozilaNaMostu++;
        break;
    
        case 1:
        while(smer==1 || kamionNaMostu>0 || autobusNaMostu>0)
        pthread_cond_wait(&pristupSever,&pristup);
        vozilaNaMostu++;
        autobusNaMostu++;
        break;
   
        case 2:
        while(smer==1 || kamionNaMostu>0 || autobusNaMostu>0 || vozilaNaMostu>0)
        pthread_cond_wait(&pristupSever,&pristup);
        vozilaNaMostu++;
        kamionNaMostu++;
        break;
    }
    
    smer=0;
    pthread_mutex_unlock(&pristup);
    printf("SEVER %d: Vozilo tipa %s prolazi kroz most\n",v->id, vozilaStr[v->tip]);
    sleep(1);
    pthread_mutex_lock(&pristup);
        switch(v->tip)
    {
        case 0:
        vozilaNaMostu--;
        break;
    
        case 1:
        vozilaNaMostu--;
        autobusNaMostu--;
        break;
   
        case 2:
        vozilaNaMostu--;
        kamionNaMostu--;
        break;
    }

        if(vozilaNaMostu==0 && kamionNaMostu==0 && autobusNaMostu==0)
        {
             smer=-1;
             pthread_cond_broadcast(&pristupJug);
        }   
        
        
        pthread_cond_broadcast(&pristupSever);
         printf("SEVER %d: Vozilo tipa %s napusta most na mostu: vozila: %d, kamiona: %d, autobusa: %d\n", v->id, vozilaStr[v->tip],vozilaNaMostu,kamionNaMostu,autobusNaMostu);
     pthread_mutex_unlock(&pristup);
   


    pthread_exit(NULL);


}

void * prelazakJug(void* arg)
{
    
    Vozilo* v = (Vozilo*)arg;



    rand()%3;
    pthread_mutex_lock(&pristup);
    
    printf("JUG %d: Vozilo tipa %s ceka pred mostom, na mostu: vozila: %d, kamiona: %d, autobusa: %d\n",v->id, vozilaStr[v->tip],vozilaNaMostu,kamionNaMostu,autobusNaMostu);
    
    switch(v->tip)
    {

    
        case 0:
        while(smer==0 || kamionNaMostu>0)
        pthread_cond_wait(&pristupJug,&pristup);
        vozilaNaMostu++;
        break;
    
        case 1:
        while(smer==0 || kamionNaMostu>0 || autobusNaMostu>0)
        pthread_cond_wait(&pristupJug,&pristup);
        vozilaNaMostu++;
        autobusNaMostu++;
        break;
   
        case 2:
        while(smer==0 || kamionNaMostu>0 || autobusNaMostu>0 || vozilaNaMostu>0)
        pthread_cond_wait(&pristupJug,&pristup);
        vozilaNaMostu++;
        kamionNaMostu++;
        break;
    }
    smer=1;
   
    pthread_mutex_unlock(&pristup);
    printf("JUG %d: Vozilo tipa %s prolazi kroz most\n",v->id, vozilaStr[v->tip]);
    sleep(1);

    pthread_mutex_lock(&pristup);
        switch(v->tip)
    {
        case 0:
        vozilaNaMostu--;
        break;
    
        case 1:
        vozilaNaMostu--;
        autobusNaMostu--;
        break;
   
        case 2:
        vozilaNaMostu--;
        kamionNaMostu--;
        break;
    }

        if(vozilaNaMostu==0 && kamionNaMostu==0 && autobusNaMostu==0)
        {
            smer=-1;
            pthread_cond_broadcast(&pristupSever);
        }    
        
        
        pthread_cond_broadcast(&pristupJug);
        printf("JUG %d: Vozilo tipa %s napusta most na mostu: vozila: %d, kamiona: %d, autobusa: %d\n", v->id, vozilaStr[v->tip],vozilaNaMostu,kamionNaMostu,autobusNaMostu);
     pthread_mutex_unlock(&pristup);
    



    pthread_exit(NULL);




}





int main()
{


    srand(123);
    pthread_t vozila[BROJ_VOZILA];

    for(int i =0;i<BROJ_VOZILA;i++)
    {
        Vozilo *v = (Vozilo*)malloc(sizeof(Vozilo));
        v->id = i;
        v->tip = rand()%3;
        v->smer = rand()%2;
       
        if(v->smer==0)
        pthread_create(vozila+i, NULL, prelazakSever, v);
        else if(v->smer==1)
        pthread_create(vozila+i, NULL, prelazakJug, v);

        
    }

    

    for(int i=0;i<BROJ_VOZILA;i++)
    {
      pthread_join(vozila[i],NULL);
    }

    pthread_exit(0);
}